function Figure1S4B()
% Running this script produces the plots shown in Figure 1 - figure
% supplement 4B

fnames = ls('*.mat');
K = size(fnames,1);

figure; hold on;
load('NHS10_preF.mat')
[p,x] = hist(log10(A./F),50); p = p./(sum(p)*(x(2)-x(1)));
area(x,p,'FaceColor',[0.5 0.5 0.5]);
load('NHS0_preF.mat')
[p,x] = hist(log10(A./F),50); p = p./(sum(p)*(x(2)-x(1)));
area(x,p); xlim([-3 0]); ylim([0 1.8]); title('Pre-F mAb'); axis square;
xlabel('log_{10}[mAb/F per particle]')
ylabel('Normalized frequency');

figure; hold on;
load('NHS10_postF.mat')
[p,x] = hist(log10(A./F),50); p = p./(sum(p)*(x(2)-x(1)));
area(x,p,'FaceColor',[0.5 0.5 0.5]);
load('NHS0_postF.mat')
[p,x] = hist(log10(A./F),50); p = p./(sum(p)*(x(2)-x(1)));
area(x,p); xlim([-3 0]); ylim([0 1.8]); title('Post-F mAb'); axis square;
xlabel('log_{10}[mAb/F per particle]')
ylabel('Normalized frequency');
